%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Virtual model Physics building departament 
% Second Floor of the Physics Building departament

  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('Representation_Model.mat')

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Segunda planta
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%------------------------------------------------------------------------%   
        % Primer edificio
        
%%------------------------------------------------------------------------%
        % Room 1 -> Seminario - Laboratorio CAP78/77
%%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 5.53 + miniwall;
        data.room(i).lE = 5.53+ miniwall; % Partido
        data.room(i).lS = 5.72+ miniwall; 
        data.room(i).lN = 5.72+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.wall(j).ma = 1;
        data.room(i).mS = 1;
        data.room(i).iS = j;
        data.wall(j+1).ma = 0;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro este
        % Parte 1
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2-door Z1];
            data.wall(j).p3 = [X2 Y2-door Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        % parte 1
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2-door Z1];
                data.wall(j).p2 = [X2-door Y2-door Z1];
                data.wall(j).p3 = [X2-door Y2-door Z2];
                data.wall(j).p4 = [X2 Y2-door Z2];
                
        % Muro este
        % Parte 2
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2-door Y2-door Z1];
            data.wall(j).p2 = [X2-door Y2 Z1];
            data.wall(j).p3 = [X2-door Y2 Z2];
            data.wall(j).p4 = [X2-door Y2-door Z2];
                
        % Muro norte
        % parte 2
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2-door Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2-door Y2 Z2];
        forLittleRoom = i;
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 2 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.11+ miniwall;
        data.room(i).lE = 4.11+ miniwall; % Partido
        data.room(i).lS = 4.22+ miniwall; 
        data.room(i).lN = 4.22+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize ;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize +data.room(i-1).lW;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Muro repetido -> Muro norte parte 2 de la sala anterior

        % Muro este
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
        
    %%-------------------------------------------------------------------------%
        % Room 3 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 3.05+ miniwall;
        data.room(i).lE = 3.05+ miniwall; % Partido
        data.room(i).lS = 4.22+ miniwall; 
        data.room(i).lN = 4.22+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize ;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Muro repetido -> Muro norte parte 2 de la sala anterior

        % Muro este
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
       
    %%-------------------------------------------------------------------------%
        % Room 4 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.89+ miniwall;
        data.room(i).lE = 2.89+ miniwall; % Partido
        data.room(i).lS = 4.22+ miniwall; 
        data.room(i).lN = 4.22+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Muro repetido -> Muro norte parte 2 de la sala anterior

        % Muro este
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 5 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.87+ miniwall;
        data.room(i).lE = 2.87+ miniwall; % Partido
        data.room(i).lS = 4.22+ miniwall; 
        data.room(i).lN = 4.22+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Muro repetido -> Muro norte parte 2 de la sala anterior

        % Muro este
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 5.5 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 3.01+ miniwall;
        data.room(i).lE = 3.01+ miniwall; % Partido
        data.room(i).lS = 4.22+ miniwall; 
        data.room(i).lN = 4.22+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Muro repetido -> Muro norte parte 2 de la sala anterior

        % Muro este
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];

        % Muro norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 6 -> Despacho DP64
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.06 + miniwall;
        data.room(i).lE = 2.06 + miniwall; % Partido
        data.room(i).lS = 5.87 + miniwall; 
        data.room(i).lN = 5.87 + miniwall; % Partido

        % Coordenadas
        X1 = wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        % Parte 1
        % Muro repetido -> Muro norte de la sala anterior

        % Muro oeste parte 2
        % Muro contenido en el muro oeste de la sala anterior
            
        % Muro sur 
        % parte 2
        j = j+1;
        data.room(i).iE = j;
            data.wall(j).p1 = [X2-1.65 Y1-1.65 Z1];
            data.wall(j).p2 = [X2  Y1-1.65 Z1];
            data.wall(j).p3 = [X2  Y1-1.65 Z2];
            data.wall(j).p4 = [X2-1.65 Y1-1.65 Z2];

        % Muro Este
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y1-1.65 Z1];
                data.wall(j).p2 = [X2 Y2 Z1];
                data.wall(j).p3 = [X2 Y2 Z2];
                data.wall(j).p4 = [X2 Y1-1.65 Z2];
                
        % Muro Norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
       
        
    %%-------------------------------------------------------------------------%
        % Room 7 -> Despacho CAP77/CD44
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 7.43+ miniwall;
        data.room(i).lE = 7.43+ miniwall; % Partido
        data.room(i).lS = 3.91+ miniwall; 
        data.room(i).lN = 3.91+ miniwall; % Partido

        % Coordenadas
        X1 = wallSize +data.room(i-1).lN ;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3) - data.room(i).lE;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        

        % Muro oeste 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
        
    
                
        % Muro Norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
      
        
    %%-------------------------------------------------------------------------%
        % Room 7 -> Despacho CAP78/CAP77 Y CD44 (TODO JUNTO)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 7.43+ miniwall;
        data.room(i).lE = 7.43+ miniwall; % Partido
        data.room(i).lS = 6.59+ miniwall; 
        data.room(i).lN = 6.59+ miniwall; % Partido
        ascensori = i;

        % Coordenadas
        X1 = data.room(i-1).x(2) ;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3) - data.room(i).lE;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        % Contenido en el muro oeste de la figura anterior

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        

        % Muro oeste 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
        
    
                
        % Muro Norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;

        
    %%-------------------------------------------------------------------------%
        % Room 8 -> Cuartos de bao
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 1.35+1.39+ miniwall*2;
        data.room(i).lE = 1.35+1.39+ miniwall*2; % Partido
        data.room(i).lS = 2.83+ miniwall; 
        data.room(i).lN = 2.83+ miniwall; % Partido

        % Coordenadas
        X1 = data.room(i-1).x(2) +4.49;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3) - 8.97;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        

        % Muro oeste 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
  
        % Muro Norte
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 9 -> Despacho CD44 (laboratoro de fsica moderna)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 9.26+ miniwall;
        data.room(i).lE = 9.26+ miniwall; 
        data.room(i).lS = 7.42+ miniwall; 
        data.room(i).lN = 7.42+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2) - data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1) - data.room(i).lE;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        

        % Muro oeste 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
  
        % Muro Norte
        % Muro partido (la otra parte est contenida en la habitacin anterior)
        j = j+1;
        data.room(i).iN = j;
                data.wall(j).p1 = [X2-2.83 Y2 Z1];
                data.wall(j).p2 = [X1 Y2 Z1];
                data.wall(j).p3 = [X1 Y2 Z2];
                data.wall(j).p4 = [X2-2.83 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 11 -> Despacho CD44 (laboratoro de fsica moderna)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.2+ miniwall;
        data.room(i).lE = 4.2+ miniwall; 
        data.room(i).lS = 5.75+ miniwall; 
        data.room(i).lN = 5.75+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1)+1.67;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        
        % Muro oeste 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2+1.55 Z1];
            data.wall(j).p3 = [X2 Y2+1.55 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
            
        % Muro este parte 2 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1-1.67 Y2+1.55 Z1];
            data.wall(j).p2 = [X1-1.67 Y2 Z1];
            data.wall(j).p3 = [X1-1.67 Y2 Z2];
            data.wall(j).p4 = [X1-1.67 Y2+1.55 Z2];
            
        % Muro sur 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1-1.67 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1-1.67 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 12 -> Despacho CD44 (laboratoro de fsica moderna)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.2+ miniwall;
        data.room(i).lE = 4.2+ miniwall; 
        data.room(i).lS = 6.52+ miniwall; 
        data.room(i).lN = 6.52+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1)-data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2-1.67 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2-1.67 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 13 -> Despacho CD44 (laboratoro de fsica moderna)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.2+ miniwall;
        data.room(i).lE = 4.2+ miniwall; 
        data.room(i).lS = 2.90+ miniwall; 
        data.room(i).lN = 2.90+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1)-data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 14 -> Despacho DP64 (laboratoro de fsica moderna)
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.2+ miniwall;
        data.room(i).lE = 4.2+ miniwall; 
        data.room(i).lS = 2.81+ miniwall; 
        data.room(i).lN = 2.81+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1)-data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
        
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 15 -> Cuartos de bao el otro edificio
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 1.32+1.37+ miniwall;
        data.room(i).lE = 1.32+1.37+ miniwall; 
        data.room(i).lS = 2.9+ miniwall; 
        data.room(i).lN = 2.9+ miniwall; 
        

        % Coordenadas
        X1 = 25.10 + 16.19 + wallSize;
        X2 = X1 + data.room(i).lS;
        Y1 = wallSize+5.78+9.40;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
        
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 16 ->Laboratorio de ptica
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 9.40+ miniwall;
        data.room(i).lE = 9.40+ miniwall; 
        data.room(i).lS = 7.41+ miniwall; 
        data.room(i).lN = 7.41+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1)-data.room(i).lE;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
        
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X2-4.51 Y2 Z1];
            data.wall(j).p3 = [X2-4.51 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 17 ->Laboratorio de ptica
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.25+ miniwall;
        data.room(i).lE = 4.25+ miniwall; 
        data.room(i).lS = 5.70+ miniwall; 
        data.room(i).lN = 5.70+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1)-5.78;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y1+5.78 Z1];
            data.wall(j).p3 = [X1 Y1+5.78 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
        % Muro sur ampliado
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X2+1.71 Y2 Z1];
            data.wall(j).p3 = [X2+1.71 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
            
        % Muro oeste ampliado
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2+1.71 Y2 Z1];
            data.wall(j).p2 = [X2+1.71 Y2+1.53 Z1];
            data.wall(j).p3 = [X2+1.71 Y2+1.53 Z2];
            data.wall(j).p4 = [X2+1.71 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 18 -> Laboratorio CAP77 CD44
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.25+ miniwall;
        data.room(i).lE = 4.25+ miniwall; 
        data.room(i).lS = 6.62+ miniwall; 
        data.room(i).lN = 6.62+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X2-4.91 Y2 Z1];
            data.wall(j).p3 = [X2-4.91 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 19 -> Laboratorio CAP77 CD44
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.25+ miniwall;
        data.room(i).lE = 4.25+ miniwall; 
        data.room(i).lS = 2.93+ miniwall; 
        data.room(i).lN = 2.93+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X2-4.91 Y2 Z1];
            data.wall(j).p3 = [X2-4.91 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
   %%-------------------------------------------------------------------------%
        % Room 20 -> Laboratorio CAP77 CD44
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.25+ miniwall;
        data.room(i).lE = 4.25+ miniwall; 
        data.room(i).lS = 2.73+ miniwall; 
        data.room(i).lN = 2.73+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 21 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.25+ miniwall;
        data.room(i).lE = 4.25+ miniwall; 
        data.room(i).lS = 5.72+ miniwall; 
        data.room(i).lN = 5.72+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2+1.41 Z1];
            data.wall(j).p3 = [X2 Y2+1.41 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2+1.41 Z1];
            data.wall(j).p2 = [X2-3.96 Y2+1.41 Z1];
            data.wall(j).p3 = [X2-3.96 Y2+1.41 Z2];
            data.wall(j).p4 = [X2 Y2+1.41 Z2];
        
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2-3.96 Y2+1.41 Z1];
            data.wall(j).p2 = [X2-3.96 Y2 Z1];
            data.wall(j).p3 = [X2-3.96 Y2 Z2];
            data.wall(j).p4 = [X2-3.96 Y2+1.41 Z2];
            
        % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y2 Z1];
            data.wall(j).p2 = [X2-3.96 Y2 Z1];
            data.wall(j).p3 = [X2-3.96 Y2 Z2];
            data.wall(j).p4 = [X1 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 22 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 4.11+ miniwall;
        data.room(i).lE = 4.11+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(2) -3.96;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3) +1.41;
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 23 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 3.05+ miniwall;
        data.room(i).lE = 3.05+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 24 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.89+ miniwall;
        data.room(i).lE = 2.89+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 25 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.87+ miniwall;
        data.room(i).lE = 2.87+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
          
    %%-------------------------------------------------------------------------%
        % Room 26 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 3.01+ miniwall;
        data.room(i).lE = 3.01+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 27 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 2.06+ miniwall;
        data.room(i).lE = 2.06+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1);
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(3);
        Y2 = Y1 + data.room(i).lW;
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        
            
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y2 Z1];
            data.wall(j).p3 = [X2 Y2 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1-1.55 Y2 Z1];
            data.wall(j).p3 = [X1-1.55 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
            
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1-1.55 Y2 Z1];
            data.wall(j).p2 = [X1-1.55 Y1-1.01 Z1];
            data.wall(j).p3 = [X1-1.55 Y1-1.01 Z2];
            data.wall(j).p4 = [X1-1.55 Y2 Z2];
            
        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1-1.55 Y1-1.01 Z1];
            data.wall(j).p2 = [X1 Y1-1.01 Z1];
            data.wall(j).p3 = [X1 Y1-1.01 Z2];
            data.wall(j).p4 = [X1-1.55 Y1-1.01 Z2];            
            
        i=i+1;
        
        
    %%-------------------------------------------------------------------------%
        % Room 28 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 7.32+ miniwall;
        data.room(i).lE = 7.32+ miniwall; 
        data.room(i).lS = 3.96+ miniwall; 
        data.room(i).lN = 3.96+ miniwall; 

        % Coordenadas
        X1 = data.room(i-1).x(1)-1.55 -  data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1)-4.27;
        Y2 = data.room(i-1).y(3);
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
   
        % Muro este
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y1 Z1];
            data.wall(j).p2 = [X2 Y1+4.25 Z1];
            data.wall(j).p3 = [X2 Y1+4.25 Z2];
            data.wall(j).p4 = [X2 Y1 Z2];
            
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
    %%-------------------------------------------------------------------------%
        % Room 29 -> Laboratorio CAP77 CD44 Esquina inferior derecha cubo 2
    %%-------------------------------------------------------------------------%
        % Longitudes paredes
        data.room(i).lW = 7.32+ miniwall;
        data.room(i).lE = 7.32+ miniwall; 
        data.room(i).lS = 6.80+ miniwall; 
        data.room(i).lN = 6.80+ miniwall; 
        iascensorde = i;

        % Coordenadas
        X1 = data.room(i-1).x(1)-data.room(i).lS;
        X2 = X1 + data.room(i).lS;
        Y1 = data.room(i-1).y(1);
        Y2 = data.room(i-1).y(3);
        Z1 = hPlanta2;
        Z2 = hPlanta3;
        data.room(i).x = [X1 X2 X2 X1];
        data.room(i).y = [Y1 Y1 Y2 Y2];
        data.room(i).z = [hPlanta2 hPlanta3];
        data.room(i).X1 = X1;
        data.room(i).X2 = X2;
        data.room(i).Y1 = Y1;
        data.room(i).Y2 = Y2;
        data.room(i).Z1 = Z1;
        data.room(i).Z2 = Z2;

        % walls
        % Muro oeste
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];

        % Muro sur
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X1 Y1 Z1];
            data.wall(j).p2 = [X2 Y1 Z1];
            data.wall(j).p3 = [X2 Y1 Z2];
            data.wall(j).p4 = [X1 Y1 Z2];
            
      % Muro Norte 
        j = j+1;
        data.room(i).iW = j;
            data.wall(j).p1 = [X2 Y2 Z1];
            data.wall(j).p2 = [X1 Y2 Z1];
            data.wall(j).p3 = [X1 Y2 Z2];
            data.wall(j).p4 = [X2 Y2 Z2];
        i=i+1;
        
        data.finSegundaPlanta = j;
        
        save('Representation_Model','data');  